-- New GrooveRadar (INCOMPLETE)

-- This gets you somewhere, but there are some definite shortcomings as it stands.

-- Maximum Note Density, Total Freeze Length, and pretty much everything about Chaos
-- will (I think) involve parsing the .sm or .ssc file notedata and that is beyond my knowledge.
-- Also, doing it with Lua will -probably- be slow, and that sort of parsing
-- should probably be done on the C++ side of things. Maybe.  I don't know.

-- Anyway, this function would ideally return a table of GrooveRadar Values that could then be
-- used to draw an ActorMultiVertex (basically, a polygon).


-- takes one argument, pn (the player number)
function GetNewGrooveRadar(pn)

	-- Get the current song as a song object
	-- this will return nil in course/oni mode
	local song = GAMESTATE:GetCurrentSong();

	-- check to ensure this isn't nil
	if song then
	
		-- Get how long the longest stepchart is in seconds.
		local duration = song:GetStepsSeconds();
	
		-- Get the last beat of the song (the number of beats).
		local lastbeat = song:GetLastBeat();


		-- get player's current chart as as steps object (might be nil)
		local currentSteps = GAMESTATE:GetCurrentSteps(pn);

		-- check to ensure there are actually steps
		if currentSteps then
		
			-- create an RadarValues object, given the current steps and the specific player
			local stepStatistics = currentSteps:GetRadarValues(pn);
		
			-- gather what we can into a table		
			local counts = {
				TapsAndHolds = stepStatistics:GetValue("RadarCategory_TapsAndHolds"),
				Jumps = stepStatistics:GetValue("RadarCategory_Jumps"),
				Holds = stepStatistics:GetValue("RadarCategory_Holds"),
				Mines = stepStatistics:GetValue("RadarCategory_Mines"),
			};

			-- StepMania doesn't have support for Shock Arrows; what's typically done is a row of 4 mines.
			-- So, you could get the mine count and divide it by 4...
			counts.ShockArrows = counts.Mines/4;
			counts.Taps = counts.TapsAndHolds - counts.Holds;

			-- average BPM (used to calculate voltage)
			local avgBPM = (60 * lastbeat)/duration;
		
			-- I don't know of any existing way to calculate this, but I'm fairly sure Mad Matt knows.
			local maxNoteDensity = counts.TapsAndHolds+counts.Jumps;

			-- I don't know of any existing way to calculate this, but Mad Matt might know.
			local totalFreezeLength = counts.Holds*2;
		
			-- Chaos, as described by:
			-- http://dancedancerevolutionddr.wikia.com/wiki/Chaos_%28Groove_Radar%29#How_to_Calculate_Chaos
			-- "the number of steps that are not on 4th notes"
			
			-- This would, again, involve parsing .sm or .ssc note data
			-- which is beyond my current knowledge.  If anyone knows, it's Mad Matt.
		
			local NewGrooveRadar = {
				stream = 60 * (counts.Taps + counts.ShockArrows)/duration,
				voltage = (avgBPM*maxNoteDensity)/4,
				air = (60 * (counts.Jumps + counts.ShockArrows))/duration,
				freeze = (10000 * totalFreezeLength)/lastbeat,
				chaos = nil
			};
			
			return NewGrooveRadar;
		end
	end
end

local t=	Def.ActorFrame{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_CENTER_Y-50);
			self:fov(80);
		end;
		Def.ActorMultiVertex{
			InitCommand=function(self)
				self:zoom(60)
				self:LoadTexture( NOTESKIN:GetPathForNoteSkin("Down","Roll Body Active","default") );
				self:texturewrapping(true);
				self:rotationy(-35);
				self:rotationx(65);
				self:SetDrawMode( "DrawMode_SymmetricQuadStrip" );
				local verts = { }
				for u=0,360,3 do
					for v = -1 , 1 do
						local X,Y,Z = x(u,v),y(u,v),z(u,v)
						local TextX = scale(v,-1,1,0,1)
						local TextY = u / 60
						table.insert( verts , {{X,Y,Z},{TextX,TextY},{1,1,1,1}} )
					end
				end
				self:AddVertices(verts)
			end;
		}
	}
return t;